/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.persistedquery;

import android.content.Context;
import android.content.res.AssetManager;
import io.github.wax911.library.annotation.processor.GraphProcessor;
import io.github.wax911.library.annotation.processor.contract.AbstractGraphProcessor;
import io.github.wax911.library.annotation.processor.plugin.AssetManagerDiscoveryPlugin;
import io.github.wax911.library.logger.core.AbstractLogger;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Consider migrating to AutomaticPersistedQueryCalculator instead", replaceWith=@ReplaceWith(expression="AutomaticPersistedQueryCalculator", imports={"io.github.wax911.library.persisted.query.AutomaticPersistedQueryCalculator"}))
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002R'\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lio/github/wax911/library/persistedquery/PersistedQueryHashCalculator;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "apqHashes", "", "", "getApqHashes", "()Ljava/util/Map;", "apqHashes$delegate", "Lkotlin/Lazy;", "graphProcessor", "Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "getGraphProcessor", "()Lio/github/wax911/library/annotation/processor/contract/AbstractGraphProcessor;", "graphProcessor$delegate", "getOrCreateAPQHash", "queryName", "createAndStoreHash", "fileKey", "hashOfQuery", "query", "Companion", "library_release"})
public final class PersistedQueryHashCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy apqHashes$delegate;
    @NotNull
    private final Lazy graphProcessor$delegate;
    private static final String TAG = PersistedQueryHashCalculator.class.getSimpleName();
    @NotNull
    private static final String ALGORITHM = "SHA-256";

    public PersistedQueryHashCalculator(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.apqHashes$delegate = LazyKt.lazy(PersistedQueryHashCalculator::apqHashes_delegate$lambda$0);
        this.graphProcessor$delegate = LazyKt.lazy(() -> PersistedQueryHashCalculator.graphProcessor_delegate$lambda$1(context));
    }

    private final Map<String, String> getApqHashes() {
        Lazy lazy = this.apqHashes$delegate;
        return (Map)lazy.getValue();
    }

    private final AbstractGraphProcessor getGraphProcessor() {
        Lazy lazy = this.graphProcessor$delegate;
        return (AbstractGraphProcessor)lazy.getValue();
    }

    @Nullable
    public final String getOrCreateAPQHash(@NotNull String queryName) {
        Intrinsics.checkNotNullParameter((Object)queryName, (String)"queryName");
        String fileKey = queryName + this.getGraphProcessor().getDefaultExtension$library_release();
        return this.getApqHashes().containsKey(fileKey) ? this.getApqHashes().get(fileKey) : this.createAndStoreHash(queryName, fileKey);
    }

    /*
     * WARNING - void declaration
     */
    private final String createAndStoreHash(String queryName, String fileKey) {
        Object v4;
        AbstractLogger abstractLogger = this.getGraphProcessor().getLogger$library_release();
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        AbstractLogger.d$default(abstractLogger, string, "Creating hash for " + queryName, null, 4, null);
        if (this.getGraphProcessor().getGraphFiles().containsKey(fileKey)) {
            void var3_3;
            String hashOfQuery = this.hashOfQuery((String)MapsKt.getValue(this.getGraphProcessor().getGraphFiles(), (Object)fileKey));
            AbstractLogger abstractLogger2 = this.getGraphProcessor().getLogger$library_release();
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            AbstractLogger.d$default(abstractLogger2, string2, "Created ", null, 4, null);
            this.getApqHashes().put(fileKey, hashOfQuery);
            v4 = var3_3;
        } else {
            AbstractLogger abstractLogger3 = this.getGraphProcessor().getLogger$library_release();
            String string3 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AbstractLogger.e$default(abstractLogger3, string3, "The request query " + fileKey + " could not be found!", null, 4, null);
            AbstractLogger abstractLogger4 = this.getGraphProcessor().getLogger$library_release();
            String string4 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            AbstractLogger.e$default(abstractLogger4, string4, "Current size of graphFiles -> size: " + this.getGraphProcessor().getGraphFiles().size(), null, 4, null);
            v4 = null;
        }
        return v4;
    }

    private final String hashOfQuery(String query) {
        MessageDigest md = MessageDigest.getInstance(ALGORITHM);
        String string = query;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        md.update(byArray);
        byte[] digest = md.digest();
        String string2 = "%064x";
        Object[] objectArray = new Object[]{new BigInteger(1, digest)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    private static final HashMap apqHashes_delegate$lambda$0() {
        return new HashMap();
    }

    private static final GraphProcessor graphProcessor_delegate$lambda$1(Context $context) {
        AssetManager assetManager = $context.getAssets();
        Intrinsics.checkNotNullExpressionValue((Object)assetManager, (String)"getAssets(...)");
        return new GraphProcessor(new AssetManagerDiscoveryPlugin(assetManager, null, null, 6, null), null, null, 6, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/github/wax911/library/persistedquery/PersistedQueryHashCalculator$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "ALGORITHM", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

