/*
 * Decompiled with CFR 0.152.
 */
package io.github.wax911.library.persistedquery;

import android.content.Context;
import android.content.res.AssetManager;
import io.github.wax911.library.annotation.processor.GraphProcessor;
import io.github.wax911.library.persistedquery.PersistedQueryHashCalculator;
import io.github.wax911.library.util.Logger;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lio/github/wax911/library/persistedquery/PersistedQueryHashCalculator;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "apqHashes", "", "", "getApqHashes", "()Ljava/util/Map;", "apqHashes$delegate", "Lkotlin/Lazy;", "graphProcessor", "Lio/github/wax911/library/annotation/processor/GraphProcessor;", "getGraphProcessor", "()Lio/github/wax911/library/annotation/processor/GraphProcessor;", "graphProcessor$delegate", "createAndStoreHash", "queryName", "fileKey", "getOrCreateAPQHash", "hashOfQuery", "query", "Companion", "library_release"})
public final class PersistedQueryHashCalculator {
    private final Lazy apqHashes$delegate = LazyKt.lazy((Function0)apqHashes.2.INSTANCE);
    private final Lazy graphProcessor$delegate;
    private static final String sha256Algorithm = "SHA-256";
    private static final String defaultExtension = ".graphql";
    public static final Companion Companion = new Companion(null);

    private final Map<String, String> getApqHashes() {
        Lazy lazy = this.apqHashes$delegate;
        PersistedQueryHashCalculator persistedQueryHashCalculator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    private final GraphProcessor getGraphProcessor() {
        Lazy lazy = this.graphProcessor$delegate;
        PersistedQueryHashCalculator persistedQueryHashCalculator = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GraphProcessor)lazy.getValue();
    }

    @Nullable
    public final String getOrCreateAPQHash(@NotNull String queryName) {
        Intrinsics.checkParameterIsNotNull((Object)queryName, (String)"queryName");
        String fileKey = queryName + defaultExtension;
        return this.getApqHashes().containsKey(fileKey) ? this.getApqHashes().get(fileKey) : this.createAndStoreHash(queryName, fileKey);
    }

    /*
     * WARNING - void declaration
     */
    private final String createAndStoreHash(String queryName, String fileKey) {
        Object v0;
        Logger.d$default(Logger.INSTANCE, this.toString(), "Creating hash for " + queryName, null, 4, null);
        if (this.getGraphProcessor().getGraphFiles().containsKey(fileKey)) {
            void var3_3;
            String hashOfQuery = this.hashOfQuery((String)MapsKt.getValue(this.getGraphProcessor().getGraphFiles(), (Object)fileKey));
            Logger.d$default(Logger.INSTANCE, this.toString(), "Created ", null, 4, null);
            this.getApqHashes().put(fileKey, hashOfQuery);
            v0 = var3_3;
        } else {
            Logger.e$default(Logger.INSTANCE, this.toString(), "The request query " + fileKey + " could not be found!", null, 4, null);
            Logger.e$default(Logger.INSTANCE, this.toString(), "Current size of graphFiles -> size: " + this.getGraphProcessor().getGraphFiles().size(), null, 4, null);
            v0 = null;
        }
        return v0;
    }

    private final String hashOfQuery(String query) {
        MessageDigest md = MessageDigest.getInstance(sha256Algorithm);
        String string = query;
        MessageDigest messageDigest = md;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        messageDigest.update(byArray2);
        byte[] digest = md.digest();
        charset = StringCompanionObject.INSTANCE;
        String string3 = "%064x";
        Object[] objectArray = new Object[]{new BigInteger(1, digest)};
        boolean bl2 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    public PersistedQueryHashCalculator(@Nullable Context context) {
        this.graphProcessor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GraphProcessor>(context){
            final /* synthetic */ Context $context;

            @NotNull
            public final GraphProcessor invoke() {
                Context context = this.$context;
                return GraphProcessor.Companion.getInstance((AssetManager)(context != null ? context.getAssets() : null));
            }
            {
                this.$context = context;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/wax911/library/persistedquery/PersistedQueryHashCalculator$Companion;", "", "()V", "defaultExtension", "", "sha256Algorithm", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

