/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.presentation;

import android.content.Context;
import android.net.Uri;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.StreamPlayerClient;
import com.ekoapp.sdk.streamplayer.R;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.operators.flowable.FlowableInterval;
import io.reactivex.schedulers.Schedulers;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020\u001cH\u0002J\u0006\u0010!\u001a\u00020\u001cJ\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u0016H\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0016H\u0002J\u0006\u0010'\u001a\u00020\u001cJ\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001cH\u0002J\u0006\u0010.\u001a\u00020\u001cJ\b\u0010/\u001a\u00020\u001cH\u0002J\b\u00100\u001a\u00020\u001cH\u0002J!\u00101\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u00102\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u00103R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/amity/socialcloud/sdk/video/presentation/AmityVideoPlayer;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "duration", "", "durationDisposable", "Lio/reactivex/disposables/Disposable;", "exoplayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "isStopWhenPause", "", "isStopped", "isVideoPlaying", "sessionId", "", "startedAt", "Lorg/joda/time/DateTime;", "kotlin.jvm.PlatformType", "title", "enableStopWhenPause", "", "getDataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DataSource$Factory;", "inflateView", "initPlayer", "pause", "play", "streamId", "url", "prepareCounting", "prepareVideo", "resume", "seekToLastWhenResume", "isPlaying", "starCounting", "partialStreamData", "Lcom/amity/socialcloud/sdk/streamapi/PartialStreamData;", "startInterval", "stop", "stopCounting", "syncPendingSession", "updateStreamSession", "endedAt", "(Ljava/lang/Long;Lorg/joda/time/DateTime;)V", "amity-video-player_release"})
public final class AmityVideoPlayer
extends LinearLayout {
    private SimpleExoPlayer exoplayer;
    private boolean isStopped;
    private boolean isVideoPlaying;
    private boolean isStopWhenPause;
    private DateTime startedAt;
    private long duration;
    private Disposable durationDisposable;
    private String title;
    private String sessionId;
    private HashMap _$_findViewCache;

    private final void inflateView() {
        View.inflate((Context)this.getContext(), (int)R.layout.view_amity_video_player, (ViewGroup)((ViewGroup)this));
    }

    public final void play(@NotNull String streamId, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.initPlayer();
        this.prepareVideo(url);
        this.prepareCounting(streamId);
    }

    public final void stop() {
        SimpleExoPlayer simpleExoPlayer = this.exoplayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.stop(true);
        }
        this.stopCounting();
    }

    public final void pause() {
        block1: {
            SimpleExoPlayer simpleExoPlayer = this.exoplayer;
            if (simpleExoPlayer != null) {
                simpleExoPlayer.setPlayWhenReady(false);
            }
            SimpleExoPlayer simpleExoPlayer2 = this.exoplayer;
            if (simpleExoPlayer2 == null) break block1;
            simpleExoPlayer2.getPlaybackState();
        }
    }

    public final void resume() {
        block1: {
            SimpleExoPlayer simpleExoPlayer = this.exoplayer;
            if (simpleExoPlayer != null) {
                simpleExoPlayer.setPlayWhenReady(true);
            }
            SimpleExoPlayer simpleExoPlayer2 = this.exoplayer;
            if (simpleExoPlayer2 == null) break block1;
            simpleExoPlayer2.getPlaybackState();
        }
    }

    public final void enableStopWhenPause() {
        this.isStopWhenPause = true;
    }

    private final void initPlayer() {
        SimpleExoPlayer simpleExoPlayer = this.exoplayer = new SimpleExoPlayer.Builder(this.getContext()).build();
        if (simpleExoPlayer != null) {
            simpleExoPlayer.setPlayWhenReady(true);
        }
        SimpleExoPlayer simpleExoPlayer2 = this.exoplayer;
        if (simpleExoPlayer2 != null) {
            simpleExoPlayer2.addListener(new Player.EventListener(this){
                final /* synthetic */ AmityVideoPlayer this$0;

                public void onIsPlayingChanged(boolean isPlaying) {
                    AmityVideoPlayer.access$setVideoPlaying$p(this.this$0, isPlaying);
                    if (AmityVideoPlayer.access$isStopWhenPause$p(this.this$0)) {
                        AmityVideoPlayer.access$seekToLastWhenResume(this.this$0, isPlaying);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
        }
        PlayerView playerView = (PlayerView)this._$_findCachedViewById(R.id.amity_video_viewer);
        Intrinsics.checkNotNullExpressionValue((Object)playerView, (String)"amity_video_viewer");
        playerView.setPlayer((Player)this.exoplayer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void seekToLastWhenResume(boolean isPlaying) {
        if (isPlaying) {
            SimpleExoPlayer simpleExoPlayer = this.exoplayer;
            if (simpleExoPlayer != null) {
                if (simpleExoPlayer.getPlaybackState() == 3) {
                    if (!this.isStopped) return;
                    SimpleExoPlayer simpleExoPlayer2 = this.exoplayer;
                    if (simpleExoPlayer2 != null) {
                        simpleExoPlayer2.seekTo(Long.MAX_VALUE);
                    }
                    this.isStopped = false;
                    return;
                }
            }
        }
        if (isPlaying) return;
        SimpleExoPlayer simpleExoPlayer = this.exoplayer;
        if (simpleExoPlayer == null) return;
        if (simpleExoPlayer.getPlaybackState() != 3) return;
        this.isStopped = true;
    }

    private final void prepareVideo(String url) {
        block0: {
            String newUrl = StringsKt.replace$default((String)url, (String)"https", (String)"http", (boolean)false, (int)4, null);
            ((PlayerView)this._$_findCachedViewById(R.id.amity_video_viewer)).requestFocus();
            ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory(this.getDataSourceFactory(), (ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(Uri.parse((String)newUrl));
            Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"ProgressiveMediaSource.F\u2026Source(Uri.parse(newUrl))");
            MediaSource videoSource = (MediaSource)progressiveMediaSource;
            SimpleExoPlayer simpleExoPlayer = this.exoplayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.prepare(videoSource);
        }
    }

    private final DataSource.Factory getDataSourceFactory() {
        return (DataSource.Factory)new DefaultDataSourceFactory(this.getContext(), Util.getUserAgent((Context)this.getContext(), (String)((Object)((Object)this)).getClass().getSimpleName()));
    }

    private final void prepareCounting(String streamId) {
        if (this.durationDisposable == null) {
            StreamPlayerClient.Companion.getFunction().getStreamData(streamId).subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<PartialStreamData>(this){
                final /* synthetic */ AmityVideoPlayer this$0;

                public final void accept(PartialStreamData it) {
                    if (it.isLive()) {
                        PartialStreamData partialStreamData = it;
                        Intrinsics.checkNotNullExpressionValue((Object)partialStreamData, (String)"it");
                        AmityVideoPlayer.access$starCounting(this.this$0, partialStreamData);
                    }
                }
                {
                    this.this$0 = amityVideoPlayer;
                }
            }).subscribe();
        }
    }

    private final void starCounting(PartialStreamData partialStreamData) {
        StreamFunctionInterface streamFunctionInterface = StreamPlayerClient.Companion.getFunction();
        String string = partialStreamData.getStreamId();
        DateTime dateTime = this.startedAt;
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"startedAt");
        streamFunctionInterface.createStreamSession(string, this.title, dateTime, partialStreamData.getResolution()).subscribeOn(Schedulers.io()).subscribe((Consumer)new Consumer<String>(this){
            final /* synthetic */ AmityVideoPlayer this$0;

            public final void accept(String it) {
                AmityVideoPlayer.access$setSessionId$p(this.this$0, it);
                AmityVideoPlayer.access$startInterval(this.this$0);
            }
            {
                this.this$0 = amityVideoPlayer;
            }
        });
    }

    private final void startInterval() {
        this.startedAt = DateTime.now();
        this.durationDisposable = new FlowableInterval(0L, 1L, TimeUnit.SECONDS, Schedulers.io()).filter((Predicate)new Predicate<Long>(this){
            final /* synthetic */ AmityVideoPlayer this$0;

            public final boolean test(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AmityVideoPlayer.access$isVideoPlaying$p(this.this$0);
            }
            {
                this.this$0 = amityVideoPlayer;
            }
        }).map((Function)new Function<Long, Long>(this){
            final /* synthetic */ AmityVideoPlayer this$0;

            public final Long apply(@NotNull Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityVideoPlayer amityVideoPlayer = this.this$0;
                long l = AmityVideoPlayer.access$getDuration$p(amityVideoPlayer);
                AmityVideoPlayer.access$setDuration$p(amityVideoPlayer, l + 1L);
                return l;
            }
            {
                this.this$0 = amityVideoPlayer;
            }
        }).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doOnNext((Consumer)new Consumer<Long>(this){
            final /* synthetic */ AmityVideoPlayer this$0;

            public final void accept(Long it) {
                DateTime endedAt = DateTime.now();
                AmityVideoPlayer.access$updateStreamSession(this.this$0, it, endedAt);
            }
            {
                this.this$0 = amityVideoPlayer;
            }
        }).subscribe();
    }

    private final void stopCounting() {
        Disposable disposable = this.durationDisposable;
        if (disposable != null) {
            if (!disposable.isDisposed()) {
                Disposable disposable2 = this.durationDisposable;
                if (disposable2 != null) {
                    disposable2.dispose();
                }
                if (this.duration > 0L) {
                    DateTime endedAt = DateTime.now();
                    CharSequence charSequence = "MMMM dd yyyy, h:mm aa";
                    DateTime dateTime = this.startedAt;
                    Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"startedAt");
                    String startTimeText = ((Object)DateFormat.format((CharSequence)charSequence, (long)dateTime.getMillis())).toString();
                    CharSequence charSequence2 = "MMMM dd yyyy, h:mm aa";
                    DateTime dateTime2 = endedAt;
                    Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"endedAt");
                    String endTimeText = ((Object)DateFormat.format((CharSequence)charSequence2, (long)dateTime2.getMillis())).toString();
                    String summaryText = " Start time : " + startTimeText + "\n End time : " + endTimeText + "\n Duration in second : " + this.duration;
                    this.updateStreamSession(this.duration, endedAt);
                    this.syncPendingSession();
                }
            }
        }
    }

    private final void updateStreamSession(Long duration, DateTime endedAt) {
        block0: {
            String string = this.sessionId;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            StreamPlayerClient.Companion.getFunction().updateStreamSession(it, duration, endedAt).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    private final void syncPendingSession() {
        StreamPlayerClient.Companion.getFunction().syncPendingSession();
    }

    public AmityVideoPlayer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public AmityVideoPlayer(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.startedAt = DateTime.now();
        this.title = "";
        this.inflateView();
    }

    public static final /* synthetic */ boolean access$isVideoPlaying$p(AmityVideoPlayer $this) {
        return $this.isVideoPlaying;
    }

    public static final /* synthetic */ void access$setVideoPlaying$p(AmityVideoPlayer $this, boolean bl) {
        $this.isVideoPlaying = bl;
    }

    public static final /* synthetic */ boolean access$isStopWhenPause$p(AmityVideoPlayer $this) {
        return $this.isStopWhenPause;
    }

    public static final /* synthetic */ void access$setStopWhenPause$p(AmityVideoPlayer $this, boolean bl) {
        $this.isStopWhenPause = bl;
    }

    public static final /* synthetic */ void access$seekToLastWhenResume(AmityVideoPlayer $this, boolean isPlaying) {
        $this.seekToLastWhenResume(isPlaying);
    }

    public static final /* synthetic */ void access$starCounting(AmityVideoPlayer $this, PartialStreamData partialStreamData) {
        $this.starCounting(partialStreamData);
    }

    public static final /* synthetic */ String access$getSessionId$p(AmityVideoPlayer $this) {
        return $this.sessionId;
    }

    public static final /* synthetic */ void access$setSessionId$p(AmityVideoPlayer $this, String string) {
        $this.sessionId = string;
    }

    public static final /* synthetic */ void access$startInterval(AmityVideoPlayer $this) {
        $this.startInterval();
    }

    public static final /* synthetic */ long access$getDuration$p(AmityVideoPlayer $this) {
        return $this.duration;
    }

    public static final /* synthetic */ void access$setDuration$p(AmityVideoPlayer $this, long l) {
        $this.duration = l;
    }

    public static final /* synthetic */ void access$updateStreamSession(AmityVideoPlayer $this, Long duration, DateTime endedAt) {
        $this.updateStreamSession(duration, endedAt);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

