/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.socket.model;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class SocketResponse {
    @SerializedName(value="status")
    String status;
    @SerializedName(value="message")
    String message;
    @SerializedName(value="code")
    int code;
    @SerializedName(value="data")
    JsonObject data;

    public String getStatus() {
        return this.status;
    }

    public boolean isSuccess() {
        Status status = Status.fromJson(this.getStatus());
        return Objects.equal((Object)((Object)status), (Object)((Object)Status.SUCCESS));
    }

    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    public JsonObject getData() {
        return this.data;
    }

    public <T> T getData(@NonNull Class<T> dataType) {
        return (T)EkoGson.get().fromJson((JsonElement)this.getData(), dataType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("status", (Object)this.status).add("message", (Object)this.message).add("code", this.code).add("data", (Object)this.data).toString();
    }

    public static enum Status {
        SUCCESS("success"),
        ERROR("error");

        final String json;

        private Status(String json) {
            this.json = json;
        }

        @NonNull
        public static Status fromJson(String jsonValue) {
            for (Status status : Status.values()) {
                if (!status.json.equals(jsonValue)) continue;
                return status;
            }
            return ERROR;
        }
    }
}

