package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "sub_channel", primaryKeys = ["channelId", "subChannelId"])
open class SubChannelEntity : EkoObject() {

    var subChannelId: String = ObjectId.get().toHexString()
    var channelId: String = ""
    var channelPublicId: String = ""
    var networkId: String = ""
    var channelType: String = "community"
    var name: String = ""
    var messageCount: Int = 0
    var isDeleted: Boolean = false
    var latestMessageId: String = ""
    var lastActivity: DateTime = DateTime.now()
    var creatorId: String = ""
    var creatorPublicId: String = ""
    var path: String = ""
    var editedAt: DateTime = DateTime.now()
    var subChannelMarkerHash: Int = 0
    var userSubChannelMarkerHash: Int = 0
    var messagePreviewId: String? = null

    override fun getId(): String {
        return subChannelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is SubChannelEntity
                && Objects.equal(subChannelId, other.subChannelId)
                && Objects.equal(channelId, other.channelId)
                && Objects.equal(channelPublicId, other.channelPublicId)
                && Objects.equal(networkId, other.networkId)
                && Objects.equal(channelType, other.channelType)
                && Objects.equal(name, other.name)
                && Objects.equal(messageCount, other.messageCount)
                && Objects.equal(isDeleted, other.isDeleted)
                && Objects.equal(latestMessageId, other.latestMessageId)
                && Objects.equal(lastActivity, other.lastActivity)
                && Objects.equal(creatorId, other.creatorId)
                && Objects.equal(creatorPublicId, other.creatorPublicId)
                && Objects.equal(path, other.path)
                && Objects.equal(editedAt, other.editedAt)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            subChannelId,
            channelId,
            channelPublicId,
            networkId,
            channelType,
            name,
            messageCount,
            isDeleted,
            latestMessageId,
            lastActivity,
            creatorId,
            creatorPublicId,
            path,
            editedAt,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("subChannelId", subChannelId)
            add("channelId", channelId)
            add("channelPublicId", channelPublicId)
            add("networkId", networkId)
            add("channelType", channelType)
            add("name", name)
            add("messageCount", messageCount)
            add("isDeleted", isDeleted)
            add("latestMessageId", latestMessageId)
            add("lastActivity", lastActivity)
            add("creatorId", creatorId)
            add("creatorPublicId", creatorPublicId)
            add("path", path)
            add("editedAt", editedAt)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}