package com.amity.socialcloud.sdk.model.core.file

import kotlinx.parcelize.Parcelize

@Parcelize
class AmityImage(private val file: AmityRawFile) : AmityFileInfo(file) {

    enum class Size {
        SMALL, MEDIUM, LARGE;

        val apiString: String
            get() = name.lowercase()
    }

    fun getUrl(size: Size): String {
        return String.format(
            "%s?size=%s",
            getUrl(),
            size.apiString
        )
    }

    fun getWidth(): Int {
        return rawFile.getMetaData()?.get("width")?.asInt ?: 0
    }

    fun getHeight(): Int {
        return rawFile.getMetaData()?.get("height")?.asInt ?: 0
    }

    fun getAltText(): String? {
        return file.getAltText()
    }

    companion object {
        fun from(rawFile: AmityRawFile): AmityImage? {
            return if (rawFile.getFileType() != AmityFileType.IMAGE) null else AmityImage(rawFile)
        }
    }

}