package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.entity.UserPresenceEntity

@Dao
abstract class UserPresenceDao : EkoObjectDao<UserPresenceEntity>() {

    @Query("DELETE from user_presence")
    abstract override fun deleteAll()

    @Query("SELECT *" +
            " from user_presence" +
            " where user_presence.userId = :userId" +
            " LIMIT 1")
    abstract fun getByUserIdNow(userId: String): UserPresenceEntity?
}