package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import com.ekoapp.ekosdk.internal.entity.FeedEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class EkoFeedDao : EkoObjectDao<FeedEntity>() {
	@Query("DELETE from feed")
	abstract override fun deleteAll()
	
	@Query("SELECT *" +
			" from feed" +
			" where feed.feedId = :feedId" +
			" LIMIT 1")
	abstract fun getByIdNowImpl(feedId: String): FeedEntity
	override fun getByIdNow(feedId: String): FeedEntity {
		return getByIdNowImpl(feedId)
	}
	
	@Query("SELECT *" +
			" from feed" +
			" where feed.feedId IN (:ids)")
	abstract fun getByIdsNowImpl(ids: List<String>): List<FeedEntity>
	override fun getByIdsNow(ids: List<String>): List<FeedEntity> {
		return getByIdsNowImpl(ids)
	}
	
	@Query("SELECT *" +
			" from feed" +
			" where feed.targetId = :targetId" +
			" and feed.feedType = :feedType")
	abstract fun getCommunityFeedImpl(targetId: String, feedType: String): Flowable<FeedEntity>
	fun getCommunityFeed(targetId: String, feedType: String): Flowable<FeedEntity> {
		return getCommunityFeedImpl(targetId, feedType)
	}
}