package com.amity.socialcloud.sdk.social.data.storytarget

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity
import com.amity.socialcloud.sdk.model.social.story.AmityStory
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget


internal class StoryTargetModelMapper : ModelMapper<StoryTargetEntity, AmityStoryTarget>() {

    override fun map(entity: StoryTargetEntity): AmityStoryTarget {
        return when (AmityStory.TargetType.enumOf(entity.targetType)) {
            AmityStory.TargetType.COMMUNITY -> {
                AmityStoryTarget.COMMUNITY(
                    uniqueId = entity.id,
                    targetId = entity.targetId,
                    mLastStoryExpiresAt = entity.lastStoryExpiresAt,
                    mLastStorySeenExpiresAt = entity.lastStorySeenExpiresAt,
                    mHasUnseen = entity.hasUnseen,
                    mLocalSortingDate = entity.localSortingDate,
                    mLocalLastStoryExpiresAt = entity.localLastStoryExpiresAt,
                    mLocalLastStorySeenExpiresAt = entity.localLastStorySeenExpiresAt,
                    community = null,
                    updatedAt = entity.updatedAt
                )
            }

            else -> AmityStoryTarget.UNKNOWN
        }
    }
}
