package com.amity.socialcloud.sdk.entity.video.stream

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.video.data.stream.StreamSessionSyncState
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Entity(tableName = "stream_session")
class EkoStreamSessionEntity : EkoObject() {

    @PrimaryKey
    var sessionId: String = ObjectId.get().toHexString()
    var streamId: String? = null
    var title: String? = null
    var watchSeconds: Long = 0L
    var startTime: DateTime? = null
    var endTime: DateTime? = null
    var resolution: String? = null
    var syncState: String = StreamSessionSyncState.PENDING.key
    var syncedAt: DateTime? = null
    var retryCount: Int = 0

    override fun getId(): String {
        return sessionId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? EkoStreamSessionEntity)?.let { stream ->
            (Objects.equal(sessionId, stream.sessionId)
                    && Objects.equal(streamId, stream.streamId)
                    && Objects.equal(title, stream.title)
                    && Objects.equal(watchSeconds, stream.watchSeconds)
                    && Objects.equal(startTime, stream.startTime)
                    && Objects.equal(endTime, stream.endTime)
                    && Objects.equal(resolution, stream.resolution)
                    && Objects.equal(syncState, stream.syncState)
                    && Objects.equal(syncedAt, stream.syncedAt)
                    && Objects.equal(retryCount, stream.retryCount))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(sessionId, streamId, title, watchSeconds,
                startTime, endTime, resolution, syncState, syncedAt)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("sessionId", sessionId)
            add("streamId", streamId)
            add("title", title)
            add("duration", watchSeconds)
            add("startedAt", startTime)
            add("endedAt", endTime)
            add("resolution", resolution)
            add("syncState", syncState)
            add("syncedAt", syncedAt)
            add("retryCount", retryCount)
        }
        return super.internalToString(toStringHelper)
    }
}