/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.Dao;
import androidx.room.Query;
import androidx.room.Transaction;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityWithCategoryDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCategoryEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import org.joda.time.DateTime;

@Dao
public abstract class EkoCommunityDao
extends EkoObjectDao<CommunityEntity> {
    private final EkoCommunityWithCategoryDao communityWithCategoryDao = UserDatabase.get().communityWithCategoryDao();

    @Override
    @Query(value="DELETE from community")
    public abstract void deleteAll();

    @Query(value="UPDATE community set isDeleted = 1 where communityId = :communityId")
    abstract Completable deleteByCommunityIdImpl(String var1);

    public Completable deleteByCommunityId(String communityId) {
        return this.deleteByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from community where community.communityId = :communityId LIMIT 1")
    abstract Flowable<CommunityEntity> getByCommunityIdImpl(String var1);

    public Flowable<CommunityEntity> getByCommunityId(String communityId) {
        return this.getByCommunityIdImpl(communityId);
    }

    @Query(value="SELECT * from community where community.communityId in (:communityIds)")
    abstract Flowable<List<CommunityEntity>> observeByCommunityIdsImpl(List<String> var1);

    public Flowable<List<CommunityEntity>> observeByCommunityIds(List<String> communityIds) {
        return this.observeByCommunityIdsImpl(communityIds);
    }

    @Override
    @Transaction
    public void insert(CommunityEntity community) {
        super.insert(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void insert(@NonNull List<? extends CommunityEntity> communities) {
        super.insert(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(CommunityEntity community) {
        super.update(community);
        EkoCategoryDao.update(community, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Override
    @Transaction
    public void update(@NonNull List<? extends CommunityEntity> communities) {
        super.update(communities);
        EkoCategoryDao.update(communities, this.communityWithCategoryDao, EkoCategoryEntity::create);
    }

    @Query(value="SELECT * from community where communityId = :communityId LIMIT 1")
    abstract CommunityEntity getByIdNowImpl(String var1);

    @Override
    public CommunityEntity getByIdNow(String communityId) {
        return this.getByIdNowImpl(communityId);
    }

    @Query(value="SELECT * from community where community.communityId IN (:ids)")
    abstract List<CommunityEntity> getByIdsNowImpl(List<String> var1);

    public List<CommunityEntity> getByIdNow(List<String> ids) {
        return this.getByIdsNowImpl(ids);
    }

    @Transaction
    public void updateIsJoined(String communityId) {
        this.updateIsJoinedImpl(communityId);
    }

    @Query(value="UPDATE community set communityId = :communityId where communityId = :communityId")
    abstract void updateIsJoinedImpl(String var1);

    @Query(value="UPDATE community set isJoined = :isJoined where communityId = :communityId")
    abstract void updateIsJoinedByCommunityIdImpl(String var1, boolean var2);

    public void updateIsJoinedByCommunityId(String communityId, boolean isJoined) {
        this.updateIsJoinedByCommunityIdImpl(communityId, isJoined);
    }

    @Query(value="SELECT * from community where community.isJoined = (case when :isFilterByMembership then :isJoined else isJoined end) and case when :isFilterByCategoryId then community.communityId in (SELECT communityId from category where categoryId in (:categoryId)) else community.communityId is not null end and community.isDeleted = (case when :isDeleted is null then isDeleted else :isDeleted end) and community.updatedAt > :now and community.communityId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by community.updatedAt  desc limit 1")
    abstract Flowable<CommunityEntity> getLatestCommunityImpl(Boolean var1, String var2, Boolean var3, Boolean var4, Boolean var5, int var6, int var7, DateTime var8);

    public Flowable<CommunityEntity> getLatestCommunity(String categoryId, AmityCommunityFilter membershipFilter, Boolean isDeleted, int hash, int nonce, DateTime now) {
        return this.getLatestCommunityImpl(!categoryId.isEmpty(), categoryId, membershipFilter != AmityCommunityFilter.ALL, membershipFilter == AmityCommunityFilter.MEMBER, isDeleted, hash, nonce, now);
    }

    @Query(value="UPDATE community set communityId = :communityId where communityId = :communityId")
    public abstract void notifyChanges(String var1);
}

