package com.amity.socialcloud.sdk.chat.data.channel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.internal.EkoChannelEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto

internal class ChannelEntityMapper : EntityMapper<EkoChannelDto, EkoChannelEntity>() {

    override fun map(list: List<EkoChannelDto>): List<EkoChannelEntity> {
        return list.map { map(it) }
    }

    fun map(dto: EkoChannelDto) : EkoChannelEntity {
        return EkoChannelEntity().apply {
            channelId = dto.channelId
            internalChannelId = dto.mid ?: ""
            path = dto.path ?: ""
            channelType = dto.type ?: ""
            displayName = dto.displayName ?: ""
            avatarFileId = dto.avatarFileId
            messageCount = dto.messageCount ?: 0
            memberCount = dto.memberCount ?: 0
            moderatorMemberCount = dto.moderatorMemberCount
            metadata = dto.getMetadata()
            setTags(dto.tags ?: AmityTags())
            isMuted = dto.isMuted ?: false
            isRateLimited = dto.isRateLimited ?: false
            isDeleted = dto.deleted ?: false
            isPublic = dto.isPublic ?: true
            lastActivity = dto.lastActivity
            messagePreviewId = dto.messagePreviewId
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }

}