package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.Ignore
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.ekoapp.ekosdk.CategoryEkoObject
import com.ekoapp.ekosdk.EkoCategoryIds
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.TaggedEkoObject
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "community", primaryKeys = ["communityId"])
open class CommunityEntity : EkoObject(), CategoryEkoObject, TaggedEkoObject {
    var communityId: String = ObjectId.get().toHexString()
    var mid: String = ""
    var path: String = ""
    var channelId: String? = null
    var userId: String? = null
    var displayName: String? = null
    var description: String? = null
    var avatarFileId: String? = null
    var isOfficial: Boolean? = false
    var isPublic: Boolean? = false
    var onlyAdminCanPost: Boolean? = false
    private var tags: AmityTags = AmityTags()
    var metadata: JsonObject? = null
    var postsCount: Int? = 0
    var membersCount: Int? = 0
    var isJoined: Boolean? = false
    var isDeleted: Boolean? = false
    var needApprovalOnPostCreation: Boolean? = false
    var allowCommentInStory: Boolean? = false
    var editedAt: DateTime? = null
    var isDiscoverable: Boolean? = null
    var requiresJoinApproval: Boolean? = null

    @Ignore
    private var user: UserEntity? = null

    @Ignore
    private var avatarFile: EkoFileEntity? = null

    @Ignore
    private var categories: List<CommunityCategoryEntity>? = null

    private var categoryIds: EkoCategoryIds = EkoCategoryIds()

    override fun getId(): String {
        return communityId
    }

    override fun getCategoryIds(): EkoCategoryIds {
        return categoryIds
    }

    override fun getTags(): AmityTags {
        return tags
    }

    fun getUser(): UserEntity? {
        return user
    }

    fun getAvatarFile(): EkoFileEntity? {
        return avatarFile
    }

    fun setCategoryIds(categoryIds: EkoCategoryIds) {
        this.categoryIds = categoryIds
    }

    fun setTags(tags: AmityTags) {
        this.tags = tags
    }

    fun setUser(user: UserEntity?) {
        this.user = user
    }

    fun setAvatarFile(avatarFile: EkoFileEntity?) {
        this.avatarFile = avatarFile
    }

    fun setCategories(categories: List<CommunityCategoryEntity>) {
        this.categories = categories
    }

    fun getCategories(): List<CommunityCategoryEntity> {
        return categories ?: listOf()
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        return (other as? CommunityEntity)?.let { community ->
            (Objects.equal(communityId, community.communityId)
                    && Objects.equal(path, community.path)
                    && Objects.equal(channelId, community.channelId)
                    && Objects.equal(userId, community.userId)
                    && Objects.equal(displayName, community.displayName)
                    && Objects.equal(description, community.description)
                    && Objects.equal(avatarFileId, community.avatarFileId)
                    && Objects.equal(isOfficial, community.isOfficial)
                    && Objects.equal(isPublic, community.isPublic)
                    && Objects.equal(onlyAdminCanPost, community.onlyAdminCanPost)
                    && Objects.equal(tags, community.tags)
                    && Objects.equal(metadata, community.metadata)
                    && Objects.equal(postsCount, community.postsCount)
                    && Objects.equal(membersCount, community.membersCount)
                    && Objects.equal(isJoined, community.isJoined)
                    && Objects.equal(isDeleted, community.isDeleted)
                    && Objects.equal(categoryIds, community.categoryIds)
                    && Objects.equal(needApprovalOnPostCreation, community.needApprovalOnPostCreation)
                    )
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
                communityId,
                path,
                channelId,
                userId,
                displayName,
                description,
                avatarFileId,
                isOfficial,
                isPublic,
                onlyAdminCanPost,
                tags,
                metadata,
                postsCount,
                membersCount,
                isJoined,
                isDeleted,
                categoryIds,
                needApprovalOnPostCreation
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("communityId", communityId)
            add("path", path)
            add("channelId", channelId)
            add("userId", userId)
            add("displayName", displayName)
            add("description", description)
            add("avatarFileId", avatarFileId)
            add("isOfficial", isOfficial)
            add("isPublic", isPublic)
            add("onlyAdminCanPost", onlyAdminCanPost)
            add("tags", tags)
            add("metadata", metadata)
            add("postsCount", postsCount)
            add("membersCount", membersCount)
            add("isJoined", isJoined)
            add("isClosed", isDeleted)
            add("categoryIds", categoryIds)
            add("needApprovalOnPostCreation", needApprovalOnPostCreation)
        }
        return super.internalToString(toStringHelper)
    }

}
