package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.PermissionEkoObject
import com.ekoapp.ekosdk.RoleEkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "channel_membership", primaryKeys = ["channelId", "userId"])
class ChannelMembershipEntity : EkoObject(), RoleEkoObject, PermissionEkoObject {

    private var id: String = ""
    var channelId: String = ObjectId.get().toHexString()
    private var userId: String = ""
    var readToSegment: Int = 0
    var lastMentionedSegment: Int = 0
    var membership: String = AmityMembershipType.NONE.apiKey
    var isMuted: Boolean = false
    var isBanned: Boolean = false
    private var roles: AmityRoles = AmityRoles()
    private var permissions: AmityPermissions = AmityPermissions()

    override fun getReferenceRoleId(): String {
        return channelId
    }

    override fun getReferencePermissionId(): String {
        return channelId
    }

    override fun getId(): String {
        return id
    }

    fun setId(id: String) {
        this.id = id
    }

    override fun getUserId(): String {
        return userId
    }

    fun setUserId(userId: String) {
        this.userId = userId
    }

    override fun getRoles(): AmityRoles {
        return roles
    }

    fun setRoles(roles: AmityRoles) {
        this.roles = roles
    }

    override fun getPermissions(): AmityPermissions {
        return permissions
    }

    fun setPermissions(permissions: AmityPermissions) {
        this.permissions = permissions
    }

    companion object {
        fun create(channelId: String, userId: String) : ChannelMembershipEntity {
            return ChannelMembershipEntity().apply {
                this.id = "$channelId#$userId"
                this.channelId = channelId
                this.userId = userId
            }
        }
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other !is ChannelMembershipEntity) return false
        if (other === this) return true
        return other.let { channelMemberShip ->
            Objects.equal(id, channelMemberShip.id)
                    && Objects.equal(userId, channelMemberShip.userId)
                    && Objects.equal(channelId, channelMemberShip.channelId)
                    && Objects.equal(readToSegment, channelMemberShip.readToSegment)
                    && Objects.equal(lastMentionedSegment, channelMemberShip.lastMentionedSegment)
                    && Objects.equal(membership, channelMemberShip.membership)
                    && Objects.equal(isMuted, channelMemberShip.isMuted)
                    && Objects.equal(isBanned, channelMemberShip.isBanned)
                    && Objects.equal(roles, channelMemberShip.roles)
                    && Objects.equal(permissions, channelMemberShip.permissions)
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            id,
            userId,
            channelId,
            readToSegment,
            lastMentionedSegment,
            membership,
            isMuted,
            isBanned,
            roles,
            permissions)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("id", id)
            add("userId", userId)
            add("channelId", channelId)
            add("readToSegment", readToSegment)
            add("lastMentionedSegment", lastMentionedSegment)
            add("membership", membership)
            add("isMuted", isMuted)
            add("isBanned", isBanned)
            add("roles", roles)
            add("permissions", permissions)
        }
        return super.internalToString(toStringHelper)
    }

}
