package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "message_tag",
		primaryKeys = ["messageId", "tagName"],
)
class EkoMessageTag constructor(
	val messageId: String,
	val tagName: String
) : EkoTagObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoMessageTag
		return (Objects.equal(messageId, other.messageId)
				&& Objects.equal(tagName, other.tagName))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				messageId,
				tagName
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("messageId", messageId)
				.add("tagName", tagName)
				.toString()
	}
	
	companion object {
		 val factory = object: EkoTagFactory<EkoMessageTag> {
				override fun create(id: String, tag: String): EkoMessageTag {
					val messageId = EkoPreconditions.checkValidId(id, "messageId")
					val tagName = EkoPreconditions.checkValidId(tag, "tagName")
					return EkoMessageTag(messageId,tagName)
				}
			}
	}
}