package com.ekoapp.ekosdk.internal.api

import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationResponse
import retrofit2.http.HTTP
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationResponse
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.Header
import retrofit2.http.POST

interface EkoNotificationApi {
	@POST("v1/notification")
	fun registerNotificationToken(@Header("X-API-Key") apiKey: String?, @Body request: RegisterDeviceForPushNotificationRequest): Single<RegisterDeviceForPushNotificationResponse>
	
	//@DELETE cannot contain @Body
	@HTTP(method = "DELETE", path = "v1/notification", hasBody = true)
	fun unregisterNotificationToken(@Header("X-API-Key") apiKey: String?, @Body request: UnregisterDeviceForPushNotificationRequest): Single<UnregisterDeviceForPushNotificationResponse>
}