package com.amity.socialcloud.sdk.video.data.stream;

import androidx.annotation.NonNull;

import com.amity.socialcloud.sdk.streamapi.PartialStreamData;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.amity.socialcloud.sdk.video.domain.stream.CreateStreamBroadcasterUseCase;
import com.amity.socialcloud.sdk.video.domain.stream.CreateStreamSessionUseCase;
import com.amity.socialcloud.sdk.video.domain.stream.DisposeStreamBroadcasterUseCase;
import com.amity.socialcloud.sdk.video.domain.stream.GetStreamDataUseCase;
import com.amity.socialcloud.sdk.video.domain.stream.SyncPendingSessionUseCase;
import com.amity.socialcloud.sdk.video.domain.stream.UpdateStreamSessionUseCase;
import com.amity.socialcloud.sdk.video.model.AmityBroadcastResolution;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Pair;

public class StreamFunction implements StreamFunctionInterface {


    public StreamFunction() {
    }

    @NonNull
    @Override
    public Single<String> createStreamSession(@NotNull String streamId, @NotNull String title,
                                              @NotNull DateTime startedAt, @NotNull String resolution) {
        return new CreateStreamSessionUseCase().execute(streamId, title, startedAt, resolution);
    }

    @NotNull
    @Override
    public Completable updateStreamSession(@NotNull String sessionId, @Nullable Long duration, @Nullable DateTime endedAt) {
        return new UpdateStreamSessionUseCase().execute(sessionId, duration, endedAt);
    }

    @Override
    public void syncPendingSession() {
        new SyncPendingSessionUseCase().execute();
    }

    @NotNull
    @Override
    public Single<PartialStreamData> getStreamData(@NotNull String streamId) {
        return new GetStreamDataUseCase().execute(streamId);
    }

    @NonNull
    @Override
    public Single<Pair<String, String>> createVideoStreaming(@NonNull String title, @NonNull String description, @NonNull AmityBroadcastResolution resolution, @androidx.annotation.Nullable String thumbnailFileId, @androidx.annotation.Nullable Boolean isSecure) {
        return new CreateStreamBroadcasterUseCase().execute(title, description, resolution, thumbnailFileId, isSecure);
    }

    @NonNull
    @Override
    public Completable disposeVideoStreaming(@NonNull String streamId) {
        return new DisposeStreamBroadcasterUseCase().execute(streamId);
    }
}
