package com.amity.socialcloud.sdk.model.social.poll

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityPoll internal constructor(
    private val pollId: String,
    private val userId: String,
    private val title: String,
    private val question: String,
    private val answers: List<AmityPollAnswer>,
    private val answerType: AnswerType,
    private val status: Status,
    private val closedAt: DateTime,
    private val isDeleted: Boolean,
    private val isVoted: Boolean,
    private val createdAt: DateTime,
    private val updatedAt: DateTime
) : Parcelable {

    fun getPollId(): String {
        return pollId
    }

    fun getUserId(): String {
        return userId
    }

    fun getTitle(): String {
        return title
    }

    fun getQuestion(): String {
        return question
    }

    fun getAnswers(): List<AmityPollAnswer> {
        return answers
    }

    fun getAnswerType(): AnswerType {
        return answerType
    }

    fun getStatus(): Status {
        return status
    }

    fun getClosedAt(): DateTime {
        return closedAt
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun isVoted(): Boolean {
        return isVoted
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    sealed class AnswerType(val value: String) : Parcelable {

        @Parcelize
        object SINGLE : AnswerType("single")

        @Parcelize
        object MULTIPLE : AnswerType("multiple")

        companion object {
            fun fromValue(value: String): AnswerType {
                return when (value) {
                    SINGLE.value -> SINGLE
                    MULTIPLE.value -> MULTIPLE
                    else -> SINGLE
                }
            }
        }
    }

    sealed class Status(val value: String) : Parcelable {

        @Parcelize
        object OPEN : Status("open")

        @Parcelize
        object CLOSED : Status("closed")

        companion object {
            fun fromValue(value: String): Status {
                return when (value) {
                    OPEN.value -> OPEN
                    CLOSED.value -> CLOSED
                    else -> CLOSED
                }
            }
        }
    }

}