package com.amity.socialcloud.sdk.api.core.permission

import com.amity.socialcloud.sdk.model.core.permission.AmityPermission
import com.ekoapp.ekosdk.internal.usecase.permission.ChannelPermissionValidatorUseCase
import io.reactivex.rxjava3.core.Flowable

class AmityChannelPermissionValidator internal constructor(
    private val permission: AmityPermission,
    private val channelId: String
) {

    fun check(): Flowable<Boolean> {
        return ChannelPermissionValidatorUseCase().execute(
            permission = permission,
            channelId = channelId
        )
    }

}