package com.amity.socialcloud.sdk.model.social.story

import android.os.Parcelable
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize

@Parcelize
sealed class AmityStoryItem(
    private val itemType: String
) : Parcelable {

    internal fun getItemType() = itemType

    internal fun getPayload(): JsonObject {
        val payload = JsonObject()
        payload.addProperty("type", itemType)
        payload.add("data", getData())
        return payload
    }
    internal abstract fun getData(): JsonObject

    class HYPERLINK(
        private val url: String,
        private val customText: String? = null,
    ) : AmityStoryItem("hyperlink") {

        fun getUrl(): String {
            return url
        }

        fun getCustomText(): String? {
            return customText
        }

        override fun getData(): JsonObject {
            val data = JsonObject()
            data.addProperty("url", url)
            customText?.let {
                data.addProperty("customText", it)
            }
            return data
        }
    }

    object UNKNOWN : AmityStoryItem("unknown") {
        override fun getData(): JsonObject {
            return JsonObject()
        }
    }


}