package com.ekoapp.ekosdk.internal.util

import com.google.common.base.Preconditions

object EkoPreconditions {
	@JvmStatic
    fun checkValidId(stringToCheck: String, name: String?): String {
		Preconditions.checkNotNull(stringToCheck, "$name is null")
		Preconditions.checkArgument(stringToCheck.isNotEmpty(), "$name is empty: \"$stringToCheck\"")
		return stringToCheck
	}
	
	fun checkValidParameter(obj: Any, name: String?): Any {
		Preconditions.checkNotNull(obj, String.format("%s is null", name))
		return obj
	}
}