package com.ekoapp.ekosdk.internal.usecase.user

import com.amity.socialcloud.sdk.model.chat.settings.AmityMembershipAcceptanceType
import com.amity.socialcloud.sdk.model.chat.settings.AmitySocialSettings
import com.amity.socialcloud.sdk.model.chat.settings.AmitySocialStorySettings
import com.ekoapp.ekosdk.internal.SocialSettingsEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Flowable

internal class GetSocialSettingsUseCase {
    fun execute(): Flowable<AmitySocialSettings> {
        val socialDao = UserDatabase.get().socialSettingsDao()
        return socialDao.getSocialSettings(SocialSettingsEntity.SOCIAL_SETTINGS_ID).map {
            AmitySocialSettings(
                isEnabled = it.enabled,
                story = AmitySocialStorySettings(
                    allowAllUserToCreateStory = it.allowAllUserToCreateStory
                ),
                membershipAcceptance = AmityMembershipAcceptanceType.enumOf(it.membershipAcceptance)
            )
        }
    }
}