package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.ekoapp.ekosdk.internal.entity.CommunityEntity
import com.google.common.base.MoreObjects
import com.google.common.base.Objects

@Entity(tableName = "category",
		primaryKeys = ["communityId", "categoryId"],
		foreignKeys = [
			ForeignKey(
				entity = CommunityEntity::class,
				parentColumns = ["communityId"],
				childColumns = ["communityId"],
				onDelete = ForeignKey.CASCADE
			)])
data class EkoCategoryEntity constructor(
	val communityId: String,
	val categoryId: String
) : EkoCategoryObject() {
	
	override fun equals(obj: Any?): Boolean {
		if (obj == null) return false
		if (obj === this) return true
		if (obj.javaClass != javaClass) return false
		val other = obj as EkoCategoryEntity
		return (Objects.equal(communityId, other.communityId)
				&& Objects.equal(categoryId, other.categoryId))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(
				communityId,
				categoryId
		)
	}
	
	override fun toString(): String {
		return MoreObjects.toStringHelper(this)
				.add("communityId", communityId)
				.add("categoryId", categoryId)
				.toString()
	}
	
	companion object {
		@JvmStatic
        fun create(communityId: String, categoryId: String): EkoCategoryEntity {
			return EkoCategoryEntity(communityId, categoryId)
		}
	}
}