package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserListMapper
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class UserEventListener: MqttEventListener<EkoUserListDto>() {

    override val type: KClass<EkoUserListDto>
        get() = EkoUserListDto::class

    override fun processEvent(dto: EkoUserListDto) {
        UserQueryPersister().persist(dto)
            .andThen(Completable.defer { UserRepository().notifyUserUpdate(dto.users!!.first()!!.userId) })
            .doOnError {
                AmityLog.e(it)
            }
            .subscribeOn(Schedulers.io())
            .subscribe()
    }

    override fun shouldProcessEvent(dto: EkoUserListDto): Boolean {
        var shouldProcessEvent = false
        val userId = dto.users?.first()?.userId
        userId?.let {
            shouldProcessEvent = UserRepository().hasInLocal(it)
        }
        return shouldProcessEvent
    }

}