package com.amity.socialcloud.sdk.chat.data.marker.reader

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.marker.channel.ChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.domain.marker.channel.SaveChannelMarkerUseCase
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.UserSubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.user.UserMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkingDto
import io.reactivex.rxjava3.core.Completable

internal class SubChannelReadingPersister : QueryPersister<SubChannelMarkingDto>() {

    override fun persist(dto: SubChannelMarkingDto): Completable {
        return SubChannelMarkerLocalDataStore().saveSubChannelMarkers(SubChannelMarkerEntityMapper().map(dto.subChannelMarkers))
                .andThen(SubChannelMarkerLocalDataStore().saveUserSubChannelMarkers(UserSubChannelMarkerEntityMapper().map(dto.userSubChannelMarkers)))
                .andThen(SaveChannelMarkerUseCase().execute(ChannelMarkerEntityMapper().map(dto.channelMarkers)))
                .andThen(UserMarkerLocalDataStore().saveUserMarkers(UserMarkerEntityMapper().map(dto.userMarkers)))
                .andThen(Completable.fromCallable {
                    dto.subChannelMarkers.map { subChannelMarkerDto ->
                        SubChannelRepository().updateMarkerHash(subChannelMarkerDto.subChannelId,subChannelMarkerDto.hashCode())
                    }
                })
                .andThen(Completable.fromCallable {
                    dto.userSubChannelMarkers.map { userSubChannelMarkerDto ->
                        SubChannelRepository().updateUserMarkerHash(userSubChannelMarkerDto.subChannelId,userSubChannelMarkerDto.hashCode())
                    }
                })
                .andThen(Completable.fromCallable {
                    dto.channelMarkers.map { channelMarkerDto ->
                        ChannelRepository().updateMarkerHash(channelMarkerDto.channelId,channelMarkerDto.hashCode())
                    }
                })
    }

}