package com.amity.socialcloud.sdk.chat.data.marker.channel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.ChannelUnreadEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto

internal class ChannelUnreadEntityMapper : EntityMapper<Pair<EkoChannelDto,EkoChannelMembershipDto?>, ChannelUnreadEntity>() {

    override fun map(list: List<Pair<EkoChannelDto,EkoChannelMembershipDto?>>): List<ChannelUnreadEntity> {
        return list.map { map(it) }
    }

    fun map(dto: Pair<EkoChannelDto,EkoChannelMembershipDto?>) : ChannelUnreadEntity {
        return ChannelUnreadEntity().apply {
            channelId = dto.first.channelId
            readToSegment = dto.second?.readToSegment
            lastSegment = dto.first.messageCount ?: 0
            lastMentionedSegment = dto.second?.lastMentionedSegment
            isDeleted = dto.first.deleted ?: false
            unreadCount = (lastSegment - (readToSegment ?: lastSegment)).let {
                if (it < 0) {
                    0
                } else {
                    it
                }
            }
            isMentioned = lastMentionedSegment?.let { it != 0 && it < lastSegment } ?: false
        }
    }

}