package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.community.JoinRequestDto
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity

class CommunityJoinRequestEntityMapper:EntityMapper<JoinRequestDto, JoinRequestEntity>() {
    override fun map(dto: List<JoinRequestDto>): List<JoinRequestEntity> {
        return dto.map { dto -> map(dto) }
    }

    private fun map(dto: JoinRequestDto): JoinRequestEntity {
        return JoinRequestEntity().apply {
            joinRequestId = dto.joinRequestId ?: ""
            type = dto.type ?: ""
            networkId = dto.networkId ?: ""
            targetId = dto.targetId ?: ""
            targetType = dto.targetType ?: ""
            userId = dto.userId ?: ""
            requestorId = dto.requestorId
            requestorInternalId = dto.requestorInternalId
            requestorPublicId = dto.requestorPublicId
            responderId = dto.responderId
            responderInternalId = dto.responderInternalId
            responderPublicId = dto.responderPublicId
            respondedAt = dto.respondedAt
            status = dto.status ?: ""
            createdDate = dto.createdAt
            updatedDate = dto.updatedAt
        }
    }
}
