package com.amity.socialcloud.sdk.model.core.ad

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.ekoapp.ekosdk.internal.data.converter.EkoGson
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityAd internal constructor(
    private val adId: String,
    private val name: String,
    private val adTarget: JsonObject?,
    internal val advertiserId: String,
    internal var advertiser: AmityAdvertiser? = null,
    internal val image1_1FileId: String?,
    internal val image9_16FileId: String?,
    internal var image1_1: AmityImage? = null,
    internal var image9_16: AmityImage? = null,
    private val headline: String,
    private val description: String,
    private val body: String,
    private val callToAction: String,
    private val callToActionUrl: String,
    private val placements: List<AmityAdPlacement>,
    private val startAt: DateTime?,
    private val endAt: DateTime?,
    private val createdAt: DateTime,
    private val updatedAt: DateTime,
) : Parcelable  {

    fun getAdId(): String {
        return adId
    }

    fun getAdTarget(): AmityAdTarget {
        return EkoGson.get().fromJson(adTarget, AmityAdTarget::class.java)
    }

    fun getAdvertiser(): AmityAdvertiser? {
        return advertiser
    }

    fun getName(): String {
        return name
    }

    fun getImage1_1(): AmityImage? {
        return image1_1
    }

    fun getImage9_16(): AmityImage? {
        return image9_16
    }

    fun getHeadline(): String {
        return headline
    }

    fun getDescription(): String {
        return description
    }

    fun getBody(): String {
        return body
    }

    fun getCallToAction(): String {
        return callToAction
    }

    fun getCallToActionUrl(): String {
        return callToActionUrl
    }

    fun getPlacements(): List<AmityAdPlacement> {
        return placements
    }

    fun getStartAt(): DateTime? {
        return startAt
    }

    fun getEndAt(): DateTime? {
        return endAt
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

}