package com.amity.socialcloud.sdk.chat.domain.channel.member

import com.amity.socialcloud.sdk.chat.data.channel.membership.ChannelMembershipRepository
import com.amity.socialcloud.sdk.chat.domain.channel.member.ChannelMemberComposerUseCase
import com.amity.socialcloud.sdk.model.chat.member.AmityChannelMember
import io.reactivex.rxjava3.core.Flowable

internal class GetChannelMemberUseCase {

    fun execute(channelId: String, userId: String) : Flowable<AmityChannelMember> {
        return ChannelMembershipRepository().observeChannelMember(channelId, userId)
            .map {
                    ChannelMemberComposerUseCase().execute(it)
                }
    }

}