package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityStorySettings
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreateCommunityUseCase {
    fun execute(
        displayName: String,
        description: String?,
        categoryIds: List<String>?,
        isPublic: Boolean?,
        metadata: JsonObject?,
        userIds: List<String>?,
        avatarFileId: String?,
        needApprovalOnPostCreation: Boolean?,
        onlyAdminCanPost: Boolean?,
        storySettings: AmityCommunityStorySettings?,
        isDiscoverable: Boolean? = null,
        requiresJoinApproval: Boolean? = null,
    ): Single<AmityCommunity> {
        return CommunityRepository().createCommunity(
            displayName,
            description,
            categoryIds,
            isPublic,
            metadata,
            userIds,
            avatarFileId,
            needApprovalOnPostCreation,
            onlyAdminCanPost,
            storySettings,
            isDiscoverable,
            requiresJoinApproval,
        ).map { CommunityComposerUseCase().execute(it) }
    }
}