package com.amity.socialcloud.sdk.chat.domain.message.preview

import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewEntityMapper
import com.amity.socialcloud.sdk.core.MessagePreviewEvent
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity

internal class MessageEventToMessagePreviewUseCase {

    fun execute(event: MessagePreviewEvent) : MessagePreviewEntity? {
        return when (event) {
            is MessagePreviewEvent.MessageCreated -> mapToMessagePreview(event.message, event.subChannel)
            is MessagePreviewEvent.MessageUpdated -> mapToMessagePreview(event.message, event.subChannel)
            is MessagePreviewEvent.MessageDeleted -> mapToMessagePreview(event.message, event.subChannel)
            else -> null
        }
    }
    
    private fun mapToMessagePreview(message: EkoMessageDto, subChannel: SubChannelDto): MessagePreviewEntity? {
        return MessagePreviewEntityMapper().let { mapper ->
            subChannel.let(mapper::toSubChannelInfo)
                ?.let { subChannelInfo ->
                    mapper.map(Pair(message.let(mapper::toMesssagePreview), subChannelInfo))
                }
        }
    }

}