package com.amity.socialcloud.sdk.api.chat

import com.amity.socialcloud.sdk.api.chat.channel.AmityChannelRepository
import com.amity.socialcloud.sdk.api.chat.message.AmityMessageRepository
import com.amity.socialcloud.sdk.api.chat.presence.AmityChannelPresenceRepository
import com.amity.socialcloud.sdk.api.chat.subchannel.AmitySubChannelRepository
import com.amity.socialcloud.sdk.model.chat.settings.AmityChatSettings
import com.ekoapp.ekosdk.internal.usecase.user.GetChatSettingsUseCase
import io.reactivex.rxjava3.core.Flowable

object AmityChatClient {

    fun newChannelRepository(): AmityChannelRepository {
        return AmityChannelRepository()
    }

    fun newSubChannelRepository(): AmitySubChannelRepository {
        return AmitySubChannelRepository()
    }

    fun newMessageRepository(): AmityMessageRepository {
        return AmityMessageRepository()
    }

    fun newChannelPresenceRepository(): AmityChannelPresenceRepository {
        return AmityChannelPresenceRepository()
    }

    fun getSettings(): Flowable<AmityChatSettings> {
        return GetChatSettingsUseCase().execute()
    }
}