package com.amity.socialcloud.sdk.api.core.reaction

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository
import com.amity.socialcloud.sdk.model.core.reaction.AmityLiveReactionReferenceType
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction
import io.reactivex.rxjava3.core.Flowable

class AmityLiveReactionRepository internal constructor() {

    fun getReactions(
        referenceId: String,
        referenceType: AmityLiveReactionReferenceType,
    ): Flowable<List<AmityLiveReaction>> {
        return ReactionRepository().observeLiveReactions(
            referenceId = referenceId,
            referenceType = referenceType,
        )
    }

    fun createReaction(
        liveStreamId: String,
        referenceId: String,
        referenceType: AmityLiveReactionReferenceType,
        reactionName: String,
    ) {
        CoreClient.createReaction(
            liveStreamId = liveStreamId,
            referenceId = referenceId,
            referenceType = referenceType,
            reactionName = reactionName,
        )
    }

}