package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.EkoFileEntity
import io.reactivex.rxjava3.core.Single

@Dao
abstract class EkoFileDao : EkoObjectDao<EkoFileEntity>() {
	@Query("DELETE from file")
	abstract override fun deleteAll()
	
	@Query("SELECT *" +
			" from file" +
			" where file.fileId = :fileId" +
			" LIMIT 1")
	abstract fun getByIdImpl(fileId: String): Single<List<EkoFileEntity>>
	fun getById(fileId: String): Single<List<EkoFileEntity>> {
		return getByIdImpl(fileId)
	}
	
	@Query("SELECT *" +
			" from file" +
			" where file.fileId = :fileId" +
			" LIMIT 1")
	abstract fun getByIdNowImpl(fileId: String): EkoFileEntity?
	override fun getByIdNow(fileId: String): EkoFileEntity? {
		return getByIdNowImpl(fileId)
	}
	
	@Query("SELECT *" +
			" from file" +
			" where file.fileId IN (:ids)")
	abstract fun getByIdsNowImpl(ids: List<String>): List<EkoFileEntity>
	override fun getByIdsNow(ids: List<String>): List<EkoFileEntity> {
		return getByIdsNowImpl(ids)
	}
}