package com.amity.socialcloud.sdk.model.core.flag

sealed class AmityContentFlagReason (open val reason: String) {
    object CommunityGuidelines : AmityContentFlagReason("Against community guidelines")
    object HarassmentOrBullying : AmityContentFlagReason("Harassment or bullying")
    object SelfHarmOrSuicide : AmityContentFlagReason("Self-harm or suicide")
    object ViolenceOrThreateningContent : AmityContentFlagReason("Violence or threatening content")
    object SellingRestrictedItems : AmityContentFlagReason("Selling and promoting restricted items")
    object SexualContentOrNudity : AmityContentFlagReason("Sexual message or nudity")
    object SpamOrScams : AmityContentFlagReason("Spam or scams")
    object FalseInformation : AmityContentFlagReason("False information or misinformation")
    data class Others(val details: String = "") : AmityContentFlagReason("Others")

    companion object {
        fun list(): List<AmityContentFlagReason> {
            return listOf(
                CommunityGuidelines,
                HarassmentOrBullying,
                SelfHarmOrSuicide,
                ViolenceOrThreateningContent,
                SellingRestrictedItems,
                SexualContentOrNudity,
                SpamOrScams,
                FalseInformation,
                Others()
            )
        }
    }
}