/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.ad;

import com.amity.socialcloud.sdk.entity.core.ad.AdEntity;
import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity;
import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\rJ\u0014\u0010\u0012\u001a\u00020\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/core/data/ad/AdLocalDataStore;", "", "()V", "deleteAllAds", "Lio/reactivex/rxjava3/core/Completable;", "getAdvertiser", "Lcom/amity/socialcloud/sdk/entity/core/ad/AdvertiserEntity;", "advertiserId", "", "getAllAds", "", "Lcom/amity/socialcloud/sdk/entity/core/ad/AdEntity;", "getSettings", "Lcom/amity/socialcloud/sdk/entity/core/ad/AdsSettingsEntity;", "saveAds", "ads", "saveAdsSettings", "settings", "saveAdvertisers", "advertisers", "amity-sdk_release"})
public final class AdLocalDataStore {
    @NotNull
    public final Completable deleteAllAds() {
        Completable completable = Completable.fromAction(AdLocalDataStore::deleteAllAds$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026t().adDao().deleteAll() }");
        return completable;
    }

    @NotNull
    public final Completable saveAds(@NotNull List<? extends AdEntity> ads) {
        Intrinsics.checkNotNullParameter(ads, (String)"ads");
        Completable completable = Completable.fromAction(() -> AdLocalDataStore.saveAds$lambda$1(ads));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026get().adDao().save(ads) }");
        return completable;
    }

    @NotNull
    public final Completable saveAdvertisers(@NotNull List<? extends AdvertiserEntity> advertisers) {
        Intrinsics.checkNotNullParameter(advertisers, (String)"advertisers");
        Completable completable = Completable.fromAction(() -> AdLocalDataStore.saveAdvertisers$lambda$2(advertisers));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026Dao().save(advertisers) }");
        return completable;
    }

    @NotNull
    public final Completable saveAdsSettings(@NotNull AdsSettingsEntity settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Completable completable = Completable.fromAction(() -> AdLocalDataStore.saveAdsSettings$lambda$3(settings));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction { UserDatabas\u2026.save(listOf(settings)) }");
        return completable;
    }

    @NotNull
    public final List<AdEntity> getAllAds() {
        return UserDatabase.get().adDao().getAllNow();
    }

    @Nullable
    public final AdvertiserEntity getAdvertiser(@NotNull String advertiserId) {
        Intrinsics.checkNotNullParameter((Object)advertiserId, (String)"advertiserId");
        return UserDatabase.get().advertiserDao().getByIdNow(advertiserId);
    }

    @Nullable
    public final AdsSettingsEntity getSettings() {
        return UserDatabase.get().adsSettingsDao().getNow();
    }

    private static final void deleteAllAds$lambda$0() {
        UserDatabase.get().adDao().deleteAll();
    }

    private static final void saveAds$lambda$1(List $ads) {
        Intrinsics.checkNotNullParameter((Object)$ads, (String)"$ads");
        UserDatabase.get().adDao().save($ads);
    }

    private static final void saveAdvertisers$lambda$2(List $advertisers) {
        Intrinsics.checkNotNullParameter((Object)$advertisers, (String)"$advertisers");
        UserDatabase.get().advertiserDao().save($advertisers);
    }

    private static final void saveAdsSettings$lambda$3(AdsSettingsEntity $settings) {
        Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
        UserDatabase.get().adsSettingsDao().save(CollectionsKt.listOf((Object)$settings));
    }
}

