/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.usecase.comment;

import com.amity.socialcloud.sdk.api.social.comment.query.AmityCommentSortOption;
import com.amity.socialcloud.sdk.model.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository;
import com.ekoapp.ekosdk.internal.usecase.comment.CommentManualQueryUseCase;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Ja\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0012J[\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002\u00a2\u0006\u0002\u0010\u0014Jc\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0011\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012J*\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JL\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/ekoapp/ekosdk/internal/usecase/comment/CommentManualQueryUseCase;", "", "()V", "execute", "Lio/reactivex/rxjava3/core/Flowable;", "", "Lcom/amity/socialcloud/sdk/model/social/comment/AmityComment;", "referenceType", "", "referenceId", "isFilterByParentId", "", "parentId", "isDeleted", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;", "ids", "hasMore", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;Ljava/util/List;Z)Lio/reactivex/rxjava3/core/Flowable;", "getCombinedResults", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/social/comment/query/AmityCommentSortOption;Ljava/util/List;)Lio/reactivex/rxjava3/core/Flowable;", "getDataSource", "observeCommentByIds", "observeLocalComments", "amity-sdk_release"})
public final class CommentManualQueryUseCase {
    @NotNull
    public final Flowable<List<AmityComment>> execute(@NotNull String referenceType, @NotNull String referenceId, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption, @NotNull List<String> ids, boolean hasMore) {
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return this.getDataSource(referenceType, referenceId, isFilterByParentId, parentId, isDeleted, sortOption, ids, hasMore);
    }

    private final Flowable<List<AmityComment>> getDataSource(String referenceType, String referenceId, boolean isFilterByParentId, String parentId, Boolean isDeleted, AmityCommentSortOption sortOption, List<String> ids, boolean hasMore) {
        Flowable<List<AmityComment>> flowable;
        Flowable<List<AmityComment>> source = null;
        if (ids.isEmpty() && hasMore) {
            Flowable<List<AmityComment>> flowable2 = Flowable.never();
            Intrinsics.checkNotNullExpressionValue((Object)flowable2, (String)"never()");
            source = flowable2;
        } else {
            source = sortOption == AmityCommentSortOption.LAST_CREATED ? this.getCombinedResults(referenceType, referenceId, isFilterByParentId, isDeleted, parentId, sortOption, ids) : (hasMore ? this.observeCommentByIds(ids, sortOption) : this.getCombinedResults(referenceType, referenceId, isFilterByParentId, isDeleted, parentId, sortOption, ids));
        }
        if ((flowable = source) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            flowable = null;
        }
        return flowable;
    }

    private final Flowable<List<AmityComment>> getCombinedResults(String referenceType, String referenceId, boolean isFilterByParentId, Boolean isDeleted, String parentId, AmityCommentSortOption sortOption, List<String> ids) {
        Flowable flowable = Flowable.combineLatest((Publisher)((Publisher)this.observeCommentByIds(ids, sortOption)), (Publisher)((Publisher)this.observeLocalComments(referenceType, referenceId, isFilterByParentId, parentId, sortOption, ids)), (BiFunction)new BiFunction(sortOption, isDeleted){
            final /* synthetic */ AmityCommentSortOption $sortOption;
            final /* synthetic */ Boolean $isDeleted;
            {
                this.$sortOption = $sortOption;
                this.$isDeleted = $isDeleted;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AmityComment> apply(@NotNull List<AmityComment> commentByIds, @NotNull List<AmityComment> localComments) {
                List list2;
                Intrinsics.checkNotNullParameter(commentByIds, (String)"commentByIds");
                Intrinsics.checkNotNullParameter(localComments, (String)"localComments");
                if (this.$sortOption == AmityCommentSortOption.LAST_CREATED) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    List comments = new ArrayList<E>();
                    comments.addAll((Collection)localComments);
                    comments.addAll((Collection)commentByIds);
                    Iterable iterable = comments;
                    Boolean bl = this.$isDeleted;
                    boolean $i$f$filter = false;
                    void var7_11 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        AmityComment it = (AmityComment)element$iv$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.isDeleted(), (Object)bl) || bl == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    List comments = new ArrayList<E>();
                    comments.addAll((Collection)commentByIds);
                    comments.addAll((Collection)localComments);
                    Iterable $this$filter$iv = comments;
                    Boolean bl = this.$isDeleted;
                    boolean $i$f$filter = false;
                    Iterable $this$filterTo$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        AmityComment it = (AmityComment)element$iv$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.isDeleted(), (Object)bl) || bl == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv;
                }
                return list2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"isDeleted: Boolean?,\n   \u2026}\n            }\n        }");
        return flowable;
    }

    private final Flowable<List<AmityComment>> observeCommentByIds(List<String> ids, AmityCommentSortOption sortOption) {
        Flowable flowable = new CommentRepository().getCommentCollection(ids, sortOption).map((Function)observeCommentByIds.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentRepository().getC\u2026       list\n            }");
        return flowable;
    }

    private final Flowable<List<AmityComment>> observeLocalComments(String referenceType, String referenceId, boolean isFilterByParentId, String parentId, AmityCommentSortOption sortOption, List<String> ids) {
        if (ids.isEmpty()) {
            Flowable flowable = new CommentRepository().observeCommentAfter(referenceType, referenceId, parentId, isFilterByParentId, sortOption, null).map((Function)observeLocalComments.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentRepository().obse\u2026   list\n                }");
            return flowable;
        }
        String offsetCommentId = sortOption == AmityCommentSortOption.LAST_CREATED ? (String)CollectionsKt.first(ids) : (String)CollectionsKt.last(ids);
        Flowable flowable = new CommentRepository().observeCommentAfter(referenceType, referenceId, parentId, isFilterByParentId, sortOption, offsetCommentId).map((Function)observeLocalComments.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"CommentRepository().obse\u2026   list\n                }");
        return flowable;
    }
}

