/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.core.domain.reaction.SyncLiveReactionsUseCase;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.NetworkConnectionEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.NetworkConnectionEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001e2\u0006\u0010\u0016\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\b\u0010%\u001a\u00020\u0015H\u0002J\b\u0010&\u001a\u00020\u0015H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "buffer", "", "", "", "Lcom/amity/socialcloud/sdk/model/core/reaction/live/AmityLiveReaction;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "isActive", "", "isSyncing", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "clearBuffer", "", "liveStreamId", "createReaction", "liveReaction", "destroy", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getReactionsToSync", "", "handleTokenExpire", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "sendLiveReactions", "reactions", "startReactionsSync", "stopReactionsSync", "syncLiveReactions", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nLiveReactionSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveReactionSyncEngine.kt\ncom/amity/socialcloud/sdk/core/LiveReactionSyncEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n1#2:165\n515#3:166\n500#3,6:167\n125#4:173\n152#4,3:174\n*S KotlinDebug\n*F\n+ 1 LiveReactionSyncEngine.kt\ncom/amity/socialcloud/sdk/core/LiveReactionSyncEngine\n*L\n99#1:166\n99#1:167,6\n102#1:173\n102#1:174,3\n*E\n"})
public final class LiveReactionSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isActive;
    @NotNull
    private final Map<String, List<AmityLiveReaction>> buffer;
    @NotNull
    private final Completable timer;
    @NotNull
    private final CompositeDisposable disposable;
    private boolean isSyncing;
    private static final long SYNC_INTERVAL_MS = 1000L;
    private static final int BUFFER_MAX_SIZE = 100;

    public LiveReactionSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.buffer = new LinkedHashMap();
        Completable completable = Flowable.interval((long)SYNC_INTERVAL_MS, (TimeUnit)TimeUnit.MILLISECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ LiveReactionSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final CompletableSource apply(long it) {
                return (CompletableSource)LiveReactionSyncEngine.access$syncLiveReactions(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"interval(SYNC_INTERVAL_M\u2026scribeOn(Schedulers.io())");
        this.timer = completable;
        this.disposable = new CompositeDisposable();
        if (Intrinsics.areEqual(sessionStateEventBus.getCurrentEvent(), (Object)SessionState.Established.INSTANCE)) {
            this.startReactionsSync();
        }
        Disposable disposable = NetworkConnectionEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(@NotNull NetworkConnectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof NetworkConnectionEvent.Connected) {
                    this.startReactionsSync();
                } else {
                    this.stopReactionsSync();
                }
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        CompositeDisposable compositeDisposable = this.disposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    /*
     * Unable to fully structure code
     */
    private final Completable syncLiveReactions() {
        block8: {
            block6: {
                block7: {
                    if (!this.buffer.isEmpty() && this.isActive && !this.isSyncing) break block7;
                    v0 = Completable.complete();
                    v1 = v0;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"{\n            Completable.complete()\n        }");
                    break block8;
                }
                this.isSyncing = true;
                var3_1 = this.buffer.keySet();
                for (T var5_3 : var3_1) {
                    it = (String)var5_3;
                    $i$a$-find-LiveReactionSyncEngine$syncLiveReactions$liveStreamId$1 = false;
                    if (this.buffer.get(it) == null) ** GOTO lbl-1000
                    v2 = this.buffer.get(it);
                    Intrinsics.checkNotNull(v2);
                    if (((Collection)v2).isEmpty() == false) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    v4 = var5_3;
                    break block6;
                }
                v4 = null;
            }
            v5 = v4;
            if (v5 == null) {
                v6 = Completable.complete();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"complete()");
                return v6;
            }
            liveStreamId = v5;
            reactions = this.getReactionsToSync(liveStreamId);
            if (((Collection)reactions).isEmpty() == false) {
                v1 = this.sendLiveReactions(liveStreamId, reactions);
            } else {
                this.isSyncing = false;
                v7 = Completable.complete();
                v1 = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"{\n                isSync\u2026.complete()\n            }");
            }
        }
        return v1;
    }

    private final Completable sendLiveReactions(String liveStreamId, List<AmityLiveReaction> reactions) {
        this.clearBuffer(liveStreamId);
        Completable completable = new SyncLiveReactionsUseCase().execute(liveStreamId, reactions).doOnComplete(() -> LiveReactionSyncEngine.sendLiveReactions$lambda$1(this)).doOnError(new Consumer(this){
            final /* synthetic */ LiveReactionSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LiveReactionSyncEngine.access$setSyncing$p(this.this$0, false);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"private fun sendLiveReac\u2026e\n                }\n    }");
        return completable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AmityLiveReaction> getReactionsToSync(String liveStreamId) {
        List list2;
        Map<String, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            boolean bl = false;
            List list3 = this.buffer.get(liveStreamId);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            list2 = list3;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void clearBuffer(String liveStreamId) {
        Map<String, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            boolean bl = false;
            this.buffer.remove(liveStreamId);
            Map<String, List<AmityLiveReaction>> map2 = this.buffer;
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                if (!(it.getValue() == null || ((List)it.getValue()).isEmpty())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl3 = false;
                object.add(this.buffer.remove(it.getKey()));
            }
            List list2 = (List)destination$iv$iv;
        }
    }

    private final void startReactionsSync() {
        this.isActive = true;
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    private final void stopReactionsSync() {
        this.isActive = false;
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
        this.isSyncing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void createReaction(@NotNull String liveStreamId, @NotNull AmityLiveReaction liveReaction) {
        Intrinsics.checkNotNullParameter((Object)liveStreamId, (String)"liveStreamId");
        Intrinsics.checkNotNullParameter((Object)liveReaction, (String)"liveReaction");
        Map<String, List<AmityLiveReaction>> map = this.buffer;
        synchronized (map) {
            boolean bl = false;
            if (!this.buffer.containsKey(liveStreamId)) {
                this.buffer.put(liveStreamId, new ArrayList());
            }
            List<AmityLiveReaction> list2 = this.buffer.get(liveStreamId);
            Boolean bl2 = list2 != null ? Boolean.valueOf(list2.add(liveReaction)) : null;
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
            this.startReactionsSync();
        } else {
            this.stopReactionsSync();
        }
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.startReactionsSync();
    }

    @Override
    public void destroy() {
        this.stopReactionsSync();
        this.clearBuffer("");
    }

    @Override
    public void handleTokenExpire() {
        this.stopReactionsSync();
    }

    private static final void sendLiveReactions$lambda$1(LiveReactionSyncEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.isSyncing = false;
    }

    public static final /* synthetic */ void access$setSyncing$p(LiveReactionSyncEngine $this, boolean bl) {
        $this.isSyncing = bl;
    }

    public static final /* synthetic */ Completable access$syncLiveReactions(LiveReactionSyncEngine $this) {
        return $this.syncLiveReactions();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/amity/socialcloud/sdk/core/LiveReactionSyncEngine$Companion;", "", "()V", "BUFFER_MAX_SIZE", "", "getBUFFER_MAX_SIZE", "()I", "SYNC_INTERVAL_MS", "", "getSYNC_INTERVAL_MS", "()J", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getSYNC_INTERVAL_MS() {
            return SYNC_INTERVAL_MS;
        }

        public final int getBUFFER_MAX_SIZE() {
            return BUFFER_MAX_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

