package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class MessagePreviewDao : EkoObjectDao<MessagePreviewEntity>() {
	@Query("SELECT * from message_preview where messagePreviewId = :messagePreviewId LIMIT 1")
	abstract fun getById(messagePreviewId: String): Flowable<MessagePreviewEntity>
	
	@Query("SELECT * from message_preview where messagePreviewId = :messagePreviewId LIMIT 1")
	abstract fun getByIdMessageIdNow(messagePreviewId: String): MessagePreviewEntity?
	
	@Query("SELECT * from message_preview where subChannelId = :subChannelId LIMIT 1")
	abstract override fun getByIdNow(subChannelId: String): MessagePreviewEntity?
	
	@Query("SELECT *" +
			" from message_preview" +
			" where message_preview.subChannelId IN (:subChannelIds)")
	abstract override fun getByIdsNow(subChannelIds: List<String>): List<MessagePreviewEntity>
	
	@Query("SELECT * from message_preview where channelId = :channelId order by updatedAt desc LIMIT 1")
	abstract fun getByChannelId(channelId: String): MessagePreviewEntity?
	
	@Query("DELETE from message_preview")
	abstract override fun deleteAll()
	
	@Query("DELETE from message_preview where messagePreviewId = :messagePreviewId")
	abstract fun deleteById(messagePreviewId: String)
	
	@Query("UPDATE message_preview set subChannelName = :subChannelName, subChannelUpdatedAt = :subChannelUpdatedAt where subChannelId = :subChannelId")
	abstract fun updateSubChannelInfo(subChannelId: String, subChannelName: String, subChannelUpdatedAt: DateTime)
	
	@Query("DELETE from message_preview where isDeleted != 0")
	abstract fun clearDeletedMessagePreviews()
	
}