package com.amity.socialcloud.sdk.social.data.community.membership

import com.amity.socialcloud.sdk.common.ModelMapper
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMember
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity

class CommunityMembershipModelMapper : ModelMapper<CommunityMembershipEntity, AmityCommunityMember>() {

    override fun map(entity: CommunityMembershipEntity): AmityCommunityMember {
        return entity.run {
            AmityCommunityMember(
                communityId = communityId,
                userId = userId,
                channelId = channelId ?: "",
                isBanned = isBanned ?: false,
                roles = roles ?: AmityRoles(),
                permissions = permissions ?: AmityPermissions(),
                createdAt = createdAt,
                updatedAt = updatedAt,
                user = null
            )
        }
    }
}