package com.amity.socialcloud.sdk.model.social.member

import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType

enum class AmityCommunityMembershipFilter constructor(val value: String, val memberships: List<String>) {

    ALL("all", listOf(AmityMembershipType.MEMBER.apiKey, AmityMembershipType.BANNED.apiKey)),
    MEMBER("member", listOf(AmityMembershipType.MEMBER.apiKey)),
    BANNED("banned", listOf(AmityMembershipType.BANNED.apiKey));

    companion object {
        fun enumOf(value: String): AmityCommunityMembershipFilter {
            return values().find { value == it.value } ?: ALL
        }
    }
}