package com.amity.socialcloud.sdk.api.chat.channel.query

import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel


class AmityChannelQueryType internal constructor() {

    fun liveType(): AmityLiveChannelQuery.Builder {
        return AmityLiveChannelQuery.Builder()
    }

    fun communityType(): AmityCommunityChannelQuery.Builder {
        return AmityCommunityChannelQuery.Builder()
    }

    fun broadcastType(): AmityBroadcastChannelQuery.Builder {
        return AmityBroadcastChannelQuery.Builder()
    }

    fun conversationType(): AmityConversationChannelQuery.Builder {
        return AmityConversationChannelQuery.Builder()
    }

    fun types(types: List<AmityChannel.Type>): AmitySelectedTypesChannelQuery.Builder {
        return AmitySelectedTypesChannelQuery.Builder().types(types)
    }

    fun all(): AmitySelectedTypesChannelQuery.Builder {
        return AmitySelectedTypesChannelQuery.Builder().types(ArrayList())
    }

}