package com.amity.socialcloud.sdk.model.social.poll

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.google.common.base.Objects
import kotlinx.android.parcel.Parcelize
import org.amity.types.ObjectId

@Parcelize
class AmityPollAnswer : Parcelable {

    val id: String = ObjectId.get().toHexString()
    val data: String = ""
    val dataType: Data = Data.UNKNOWN
    val voteCount: Int = 0
    val isVotedByUser: Boolean = false
    val fileId: String? = null
    val image: AmityImage? = if (fileId != null) ImageGetUseCase().execute(fileId) else null

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? AmityPollAnswer)?.let { answer ->
            (Objects.equal(id, answer.id)
                    && Objects.equal(data, answer.data)
                    && Objects.equal(dataType, answer.dataType)
                    && Objects.equal(fileId, answer.fileId)
                    && Objects.equal(voteCount, answer.voteCount)
                    && Objects.equal(isVotedByUser, answer.isVotedByUser))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            id,
            data,
            dataType,
            fileId,
            voteCount,
            isVotedByUser
        )
    }

    sealed class Data(val apiKey: String) : Parcelable {

        @Parcelize
        data class TEXT(val text: String) : Data("text")

        @Parcelize
        data class IMAGE(val text: String, val fileId: String) : Data("image")

        @Parcelize
        internal object UNKNOWN : Data("unknown")
    }
}