package com.amity.socialcloud.sdk.core.session.model

import com.amity.socialcloud.sdk.model.core.error.AmityException

sealed class AppEvent {

    // access token watcher events
    object TokenAboutToExpire : AppEvent()
    object TokenExpire : AppEvent()
    // session state diagram events
    object AppLaunchWithUser : AppEvent()
    object AppLaunchWithoutUser : AppEvent()
    object LoggingIn : AppEvent()
    object LoginFail : AppEvent()
    object LoginSuccess : AppEvent()
    class TerminationCodeReceive (val error: AmityException) : AppEvent()
    object ManualLogout : AppEvent()
    object TokenRenewSuccess : AppEvent()
    // utils event
    object SendNetworkRequest : AppEvent()
    object AppForeground : AppEvent()

}