package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.ForeignKey
import com.amity.socialcloud.sdk.core.data.user.UserRepository
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.ekoapp.ekosdk.EkoFlag
import com.ekoapp.ekosdk.EkoObject
import com.ekoapp.ekosdk.internal.EkoLocalFlag
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.google.common.base.Objects
import com.google.gson.annotations.SerializedName
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

@Entity(tableName = "user_flag",
		primaryKeys = ["userId"],
		foreignKeys = [
			ForeignKey(
				entity = UserEntity::class,
				parentColumns = ["userId"],
				childColumns = ["userId"],
				onDelete = ForeignKey.CASCADE
			)])
data class EkoUserFlag constructor(
	val userId: String,
	@SerializedName("hashFlag")
	var flag: EkoFlag? = null,
	var localFlag: EkoLocalFlag? = null
) : EkoObject() {
	
	override fun getId(): String {
		return userId
	}
	
	val isFlaggedByMe: Boolean
		get() {
			flag?.let { flag ->
				val mightFlaggedByMe = flag.mightFlaggedByMe()
				val local = localFlag ?: EkoLocalFlag().apply {
					localFlag = this
				}
				if (mightFlaggedByMe && !Objects.equal(flag.hash, local.syncedUpHash)) {
					Single.just(userId)
							.filter { id: String -> flag.expired(id) }
							.flatMapSingle { userId: String -> UserRepository().isFlaggedByMe(userId) }
							.doOnSuccess { isFlaggedByMe: Boolean ->
								local.isFlaggedByMe = isFlaggedByMe
								local.syncedUpHash = flag.hash
								localFlag = local
								UserDatabase.get().userFlagDao().update(this)
							}
							.subscribe()
					return true
				}
				return mightFlaggedByMe && localFlag!!.isFlaggedByMe
			} ?: localFlag?.let {
				Completable.fromAction {
					localFlag = null
					UserDatabase.get().userFlagDao().update(this)
				}
						.subscribeOn(Schedulers.io())
						.subscribe()
			}
			return false
		}
	
	override fun equals(obj: Any?): Boolean {
		return (super.equals(obj)
				&& Objects.equal(flag, (obj as EkoUserFlag).flag)
				&& Objects.equal(localFlag, obj.localFlag))
	}
	
	override fun hashCode(): Int {
		return Objects.hashCode(super.hashCode(), flag, localFlag)
	}
}