package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;

@Dao
public abstract class EkoMqttUrlDao {

    @Query("SELECT * from mqtt_url LIMIT 1")
    public abstract Flowable<EkoMqttUrl> getCurrentMqttUrlFlowable();

    @Query("SELECT * from mqtt_url LIMIT 1")
    public abstract Maybe<EkoMqttUrl> getCurrentMqttUrl();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(EkoMqttUrl url);
}
