package com.amity.socialcloud.sdk.chat.data.marker.message

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.chat.message.MessageDeliveredMembershipFilter
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter
import com.ekoapp.ekosdk.internal.MessageMarkerEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class MessageMarkerLocalDataStore {
    
    fun getMessageMarker(messageId: String): MessageMarkerEntity? {
        return UserDatabase.get().messageMarkerDao().getByIdNow(messageId)
    }
    
    fun saveMessageMarkers(
        messageMarkers: List<MessageMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().messageMarkerDao().save(messageMarkers)
        }
    }
    
    fun saveAndUpdatePreviousMessageMarkers(
        messageMarkers: List<MessageMarkerEntity>,
    ): Completable {
        return Completable.fromAction {
            messageMarkers.map(::saveAndUpdatePreviousMessageMarker)
        }
    }
    
    fun saveAndUpdatePreviousMessageMarker(marker: MessageMarkerEntity) {
        val messageDao = UserDatabase.get().messageDao()
        val message = try {
            messageDao.getByMessageIdNow(marker.messageId)
        } catch (e: Exception) {
            null
        }
        val isCreator = message?.userId == AmityCoreClient.getUserId()
        val messageMarkerDao = UserDatabase.get().messageMarkerDao()
        if (isCreator) {
            messageMarkerDao.save(listOf(marker))
        }
        messageMarkerDao
            .updatePreviousMarkersReadCount(
                marker.subChannelId,
                marker.readCount,
                marker.createdAt
            )
        messageMarkerDao
            .updatePreviousMarkersDeliveredCount(
                marker.subChannelId,
                marker.deliveredCount,
                marker.createdAt
            )
    }
    
    fun saveLocalMessageMarkers(markers: List<MessageMarkerEntity>) {
        UserDatabase.get().messageMarkerDao().save(markers)
    }
    
    fun getMessageReadUsersPagingSource(
        messageId: String,
        memberships: List<MessageReadMembershipFilter>,
    ): PagingSource<Int, UserEntity> {
        return UserDatabase.get().messageReadUsersPagingDao().getMessageReadUsersPagingSource(
            messageId,
            memberships
        )
    }
    
    fun getMessageDeliveredUsersPagingSource(
            messageId: String,
            memberships: List<MessageDeliveredMembershipFilter>,
    ): PagingSource<Int, UserEntity> {
        return UserDatabase.get().messageDeliveredUsersPagingDao().getMessageDeliveredUsersPagingSource(
                messageId,
                memberships
        )
    }
}