package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "read_receipt", primaryKeys = ["subChannelId"])
open class SubChannelReadReceiptEntity : EkoObject() {

    var subChannelId: String = ObjectId.get().toHexString()
    var latestSegment: Int = 0
    var latestSyncSegment: Int = 0

    override fun getId(): String {
        return subChannelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is SubChannelReadReceiptEntity
            && Objects.equal(subChannelId, other.subChannelId)
            && Objects.equal(latestSegment, other.latestSegment)
            && Objects.equal(latestSyncSegment, other.latestSyncSegment)
            && Objects.equal(createdAt, other.createdAt)
            && Objects.equal(updatedAt, other.updatedAt)
            )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            subChannelId,
            latestSegment,
            latestSyncSegment,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("subChannelId", subChannelId)
            add("latestSegment", latestSegment)
            add("latestSyncSegment", latestSyncSegment)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}