package com.amity.socialcloud.sdk.chat.domain.message.preview

import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository
import com.amity.socialcloud.sdk.chat.data.message.preview.MessagePreviewRepository
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.ekoapp.ekosdk.internal.data.model.MessagePreviewEntity
import io.reactivex.rxjava3.core.Completable

internal class MessagePreviewSaveUseCase {
    fun execute(messagePreview: MessagePreviewEntity) : Completable {
        val messagePreviewRepository = MessagePreviewRepository()
        val cachedMessagePreview = messagePreviewRepository.getMessagePreviewBySubChannelId(messagePreview.subChannelId)
        val channelMessagePreview = messagePreviewRepository.getMessagePreviewByChannelId(messagePreview.channelId)
        return if (cachedMessagePreview == null || messagePreview.segment > cachedMessagePreview.segment) {
            messagePreviewRepository.saveMessagePreview(messagePreview)
                .andThen(
                    SubChannelRepository()
                        .updateMessagePreview(messagePreview.subChannelId,messagePreview.messagePreviewId)
                        .onErrorComplete()
                )
                .andThen(
                    if(channelMessagePreview?.createdAt?.isBefore(messagePreview.createdAt) != false) {
                        ChannelRepository()
                            .updateMessagePreview(messagePreview.channelId,messagePreview.messagePreviewId)
                            .onErrorComplete()
                    } else {
                        Completable.complete()
                    }
                )
        } else {
            Completable.complete()
        }
    }

}