package com.amity.socialcloud.sdk.chat.data.marker.readuser.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.chat.data.channel.paging.MessageReadUsersKeyCreator
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageReadUsersPersister
import com.amity.socialcloud.sdk.chat.data.marker.readuser.MessageReadUsersRequest
import com.amity.socialcloud.sdk.chat.domain.marker.message.MessageReadUsersComposerUseCase
import com.amity.socialcloud.sdk.core.data.user.UserListPersister
import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.amity.socialcloud.sdk.model.chat.message.MessageReadMembershipFilter
import com.ekoapp.ekosdk.internal.api.dto.MessageReadUsersQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.QueryStreamMediator
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Single

internal class MessageReadUsersMediator(
    private val messageId: String,
    private val memberships: List<MessageReadMembershipFilter>,
) : QueryStreamMediator<UserEntity, MessageReadUsersQueryDto>(
    nonce = AmityNonce.MESSAGE_READ_USERS,
    queryStreamKeyCreator = MessageReadUsersKeyCreator(
        messageId = messageId,
        memberships = memberships,
    )
) {

    override fun forceRefresh() = true

    override fun getFirstPageRequest(pageSize: Int): Single<MessageReadUsersQueryDto> {
        return getRequest(limit = pageSize)

    }

    override fun getFetchByTokenRequest(token: String): Single<MessageReadUsersQueryDto> {
        return getRequest(token = token)
    }

    override fun persistResponse(dto: MessageReadUsersQueryDto): Completable {
        return MessageReadUsersPersister().persist(dto).toRx2()
        
    }

    override fun convertResponseToQueryToken(dto: MessageReadUsersQueryDto): QueryStreamQueryToken {
        return QueryStreamQueryToken(
            queryStreamKeyCreator = queryStreamKeyCreator,
            next = dto.token?.next,
            previous = dto.token?.previous,
            primaryKeys = dto.userIds
        )
    }
    
    private fun getRequest(
        limit: Int? = null,
        token: String? = null
    ): Single<MessageReadUsersQueryDto> {
        val request = MessageReadUsersRequest(messageId, memberships, limit, token)
        return MessageReadUsersComposerUseCase().execute(request).toRx2()
    }

}